<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The pricing scheme details.
 */
class PricingScheme implements \JsonSerializable
{
    /**
     * @var Money|null
     */
    private $price;

    /**
     * @var string
     */
    private $pricingModel;

    /**
     * @var Money|null
     */
    private $reloadThresholdAmount;

    /**
     * @param string $pricingModel
     */
    public function __construct(string $pricingModel)
    {
        $this->pricingModel = $pricingModel;
    }

    /**
     * Returns Price.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getPrice(): ?Money
    {
        return $this->price;
    }

    /**
     * Sets Price.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps price
     */
    public function setPrice(?Money $price): void
    {
        $this->price = $price;
    }

    /**
     * Returns Pricing Model.
     * The pricing model for the billing cycle.
     */
    public function getPricingModel(): string
    {
        return $this->pricingModel;
    }

    /**
     * Sets Pricing Model.
     * The pricing model for the billing cycle.
     *
     * @required
     * @maps pricing_model
     */
    public function setPricingModel(string $pricingModel): void
    {
        $this->pricingModel = $pricingModel;
    }

    /**
     * Returns Reload Threshold Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getReloadThresholdAmount(): ?Money
    {
        return $this->reloadThresholdAmount;
    }

    /**
     * Sets Reload Threshold Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps reload_threshold_amount
     */
    public function setReloadThresholdAmount(?Money $reloadThresholdAmount): void
    {
        $this->reloadThresholdAmount = $reloadThresholdAmount;
    }

    /**
     * Converts the PricingScheme object to a human-readable string representation.
     *
     * @return string The string representation of the PricingScheme object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PricingScheme',
            [
                'price' => $this->price,
                'pricingModel' => $this->pricingModel,
                'reloadThresholdAmount' => $this->reloadThresholdAmount
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->price)) {
            $json['price']                   = $this->price;
        }
        $json['pricing_model']               = $this->pricingModel;
        if (isset($this->reloadThresholdAmount)) {
            $json['reload_threshold_amount'] = $this->reloadThresholdAmount;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
